class US_HUD extends ChallengeHUD;

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

//Import Textures:
#exec Texture Import File=Textures\USlogo.bmp Name=USlogo Group=HUD MIPS=ON
#exec Texture Import File=Textures\USlogoA.bmp Name=USlogoA Group=HUD MIPS=ON
#exec Texture Import File=Textures\USlogoB.bmp Name=USlogoB Group=HUD MIPS=ON
#exec Texture Import File=Textures\USlogoC.bmp Name=USlogoC Group=HUD MIPS=ON
#exec Texture Import File=Textures\Frame.bmp Name=Frame Group=HUD MIPS=ON
#exec Texture Import File=Textures\Frame2.bmp Name=Frame2 Group=HUD MIPS=ON
#exec Texture Import File=Textures\Background.bmp Name=Backie Group=HUD MIPS=ON
#exec Texture Import File=Textures\ScoreElementL.bmp Name=ScoreElementL Group=HUD MIPS=ON
#exec Texture Import File=Textures\ScoreElementM.bmp Name=ScoreElementM Group=HUD MIPS=ON
#exec Texture Import File=Textures\ScoreElementR.bmp Name=ScoreElementR Group=HUD MIPS=ON
#exec Texture Import File=Textures\Heart.bmp Name=Heart Group=HUD MIPS=ON
#exec Texture Import File=Textures\Shield.bmp Name=Shield Group=HUD MIPS=ON
#exec Texture Import File=Textures\JumpBoots.bmp Name=JumpBoots Group=HUD MIPS=ON
#exec Texture Import File=Textures\DollarIcon.bmp Name=DollarIcon Group=HUD MIPS=ON
#exec Texture Import File=Textures\StatPointIcon.bmp Name=StatPointIcon Group=HUD MIPS=ON
#exec Texture Import File=Textures\SoulIcon.bmp Name=SoulIcon Group=HUD MIPS=ON
#exec Texture Import File=Textures\Icon_Enforcer.bmp Name=Icon_Enforcer Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_Minigun.bmp Name=Icon_Minigun Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_SniperRifle.bmp Name=Icon_SniperRifle Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_Translocator.bmp Name=Icon_Translocator Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_Eightball.bmp Name=Icon_Eightball Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_BioRifle.bmp Name=Icon_BioRifle Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_FlakCannon.bmp Name=Icon_FlakCannon Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_PulseGun.bmp Name=Icon_PulseGun Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_RazorJack.bmp Name=Icon_RazorJack Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_ShockRifle.bmp Name=Icon_ShockRifle Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_Uzi.bmp Name=Icon_Uzi Group=Items MIPS=ON
#exec Texture Import File=Textures\Ammo.bmp Name=Icon_Ammo Group=Items MIPS=ON
#exec Texture Import File=Textures\Health.bmp Name=Icon_Health Group=Items MIPS=ON
#exec Texture Import File=Textures\Armor.bmp Name=Icon_Armor Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_Soldiers.bmp Name=Icon_Soldiers Group=Items MIPS=ON
#exec Texture Import File=Textures\Icon_Monsters.bmp Name=Icon_Monsters Group=Items MIPS=ON
#exec Texture Import File=Textures\SpeedRelic.bmp Name=SpeedRelic Group=Relics MIPS=ON
#exec Texture Import File=Textures\DamageRelic.bmp Name=DamageRelic Group=Relics MIPS=ON
#exec Texture Import File=Textures\DefenceRelic.bmp Name=DefenceRelic Group=Relics MIPS=ON
#exec Texture Import File=Textures\AuraRelic.bmp Name=AuraRelic Group=Relics MIPS=ON
#exec Texture Import File=Textures\HealthRegenRelic.bmp Name=HealthRegenRelic Group=Relics MIPS=ON
#exec Texture Import File=Textures\RadarRelic.bmp Name=RadarRelic Group=Relics MIPS=ON
#exec Texture Import File=Textures\LevelUp.bmp Name=LevelUp Group=HUD MIPS=ON
#exec Texture Import File=Textures\RadarCircle.bmp Name=RadarCircle Group=HUD MIPS=ON

// Added custom imports for the adjusted HUD overlay
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2

//Custom variables:
var bool bRenderIntro, bShot1, bShot2, bShot3, bLogoFadeIn, BlogoFadeOut, bLevelUp, bLevelSet;
var int ShowIntroTime, Atime, Btime, Ctime, LogoFadeColor, HeadLineFadeColor, OldLevel;
var color LogoColor, HeadLineColor;

// ADDED var's for gopo HUD addition
var Texture TeamBeaconIcon;
var color BeaconColor;

//End Custom Variable

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

//var globalconfig int CrosshairCount;
//var globalconfig string CrossHairs[20];
//var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
//var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
//var globalconfig bool bUseTeamColor;
//var globalconfig byte Opacity;	// should be between 1 and 16
//var globalconfig float HUDScale, StatusScale, WeaponScale;
//var globalconfig color FavoriteHUDColor, CrosshairColor;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var globalconfig string FontInfoClass;

var string	IDstring, version;

//DrawUS vars:
var float Speed, a, b, l, d, e, f, g, h, j, k, r, m, n, o, p ,q, s;
var bool bSetStart;

var float Lscale;
/*
simulated function DrawDroppedWeapons(Canvas Canvas)
{
	local UniversalSoldiersWeapon USW;
	local float 	Ypos, XL, YL, Xpos, Dist;
	local Vector	dir;
	local Vector	loc;
	local Vector	X,Y,Z;
	
	if (PlayerOwner == None)
	{
		return;
	}

	GetAxes(Owner.Rotation, X, Y, Z);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'UniversalSoldiersWeapon', USW, 750, Owner.Location, true)
		{

		Dir = USW.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		Canvas.StrLen(USW.HUDname, XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * Canvas.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > Canvas.ClipX - XL)
				{
				Xpos = Canvas.ClipX - XL;
				}
			YPos = 0.5 * Canvas.ClipY * (1 - 1.4 * (Dir Dot Z));
			Canvas.SetPos(Xpos , YPos );
			Canvas.DrawColor = USW.HUDcolor;
			Canvas.DrawText(USW.HUDname, true);
			}
		}
}
*/
simulated function DrawRadar(Canvas Canvas)
{
local Pawn P;
local float 	Ypos, XL, YL, Xpos, Dist, Rscale;
local Vector	dir;
local Vector	loc;
local Vector	X,Y,Z;
	
	if (PlayerOwner == None)
	{
		return;
	}

	GetAxes(Owner.Rotation, X, Y, Z);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = RedColor;
	Canvas.Style = ERenderStyle.STY_Translucent;

	foreach VisibleCollidingActors(class'Pawn', P, 10000, Owner.Location, true)
		{

		Dir = P.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		Rscale = 500 / Dist;
		if ( Rscale > 1 )
			Rscale = 1;
		else if ( Rscale < 0 )
			Rscale = 0.01;
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * Canvas.ClipX * (1 + 1.25 * (Dir Dot Y));//1.3
			YPos = 0.5 * Canvas.ClipY * (1 - 1.2 * (Dir Dot Z));//1.4
			Canvas.SetPos(Xpos - 128 * Rscale , YPos - 128 * Rscale);
			Canvas.DrawTile(texture'RadarCircle', 256 * Rscale, 256 * Rscale, 0, 0, 256, 256);
			}
		}
}

simulated function DrawLevelUp( canvas Canvas )
{
	if (!bLevelSet)
		{
		OldLevel = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Level;
		bLevelSet = True;
		Lscale = 25;
		}

	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Level > OldLevel )
		{
		OldLevel = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Level;
		bLevelUp = True;
		}
	if (bLevelUp)
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;

		Canvas.SetPos( Canvas.ClipX * 0.5 - 128 * Lscale , Canvas.ClipY * 0.5 - 64 * Lscale );
		Canvas.DrawTile(texture'LevelUp', 256 * Lscale, 128 * Lscale, 0, 0, 256, 128);
		
		Lscale -= 0.20;
		if ( Lscale < 0 )
			{
			Lscale = 25;
			bLevelUp = False;
			}
		}
}

simulated function DrawTopPlayers( canvas Canvas )
{
local Float Xpos, Ypos, XL, YL;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Test", XL, YL);

	Xpos = Canvas.ClipX * 0.1;
	YL -= 2;
	Ypos = 96;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Freezy Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Freezy10, True);

	Xpos = Canvas.ClipX * 0.45;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Gordon Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Gordon10, True);

	Xpos = Canvas.ClipX * 0.8;
	
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Ninja Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Ninja10, True);

	Xpos = Canvas.ClipX * 0.1;
	Ypos += 12 * YL;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Cyclop Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyclop10, True);

	Xpos = Canvas.ClipX * 0.45;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Tensor Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Tensor10, True);

	Xpos = Canvas.ClipX * 0.8;
	
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Vampire Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Vampire10, True);

	Xpos = Canvas.ClipX * 0.1;
	Ypos += 12 * YL;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Trooper Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Trooper10, True);

	Xpos = Canvas.ClipX * 0.45;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Snake Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Snake10, True);

	Xpos = Canvas.ClipX * 0.8;
	
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Hitman Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Hitman10, True);

	Xpos = Canvas.ClipX * 0.45;
	Ypos += 12 * YL;

	Canvas.DrawColor = GoldColor;
	Canvas.SetPos( Xpos , Ypos - YL );
	Canvas.DrawText("Best Cyborg Players:", True);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos( Xpos , Ypos );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg1, True);
	Canvas.SetPos( Xpos , Ypos + YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg2, True);
	Canvas.SetPos( Xpos , Ypos + 2 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg3, True);
	Canvas.SetPos( Xpos , Ypos + 3 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg4, True);
	Canvas.SetPos( Xpos , Ypos + 4 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg5, True);
	Canvas.SetPos( Xpos , Ypos + 5 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg6, True);
	Canvas.SetPos( Xpos , Ypos + 6 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg7, True);
	Canvas.SetPos( Xpos , Ypos + 7 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg8, True);
	Canvas.SetPos( Xpos , Ypos + 8 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg9, True);
	Canvas.SetPos( Xpos , Ypos + 9 * YL );
	Canvas.DrawText(US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Cyborg10, True);

}

simulated function DrawF2logo( canvas Canvas )
{
local Float Xpos, Ypos;

	DrawTopPlayers(canvas);

	//Draw Characters:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;

	Xpos = Canvas.ClipX * 0.1 - 64;
	Ypos = 80;

	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Freezy', 64, 128, 0, 0, 128, 256);
	Xpos = Canvas.ClipX * 0.45 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Gordon', 64, 128, 0, 0, 128, 256);
	Xpos = Canvas.ClipX * 0.8 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Ninja', 64, 128, 0, 0, 128, 256);

	Xpos = Canvas.ClipX * 0.1 - 64;
	Ypos += 192;

	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Cyclop', 64, 128, 0, 0, 128, 256);
	Xpos = Canvas.ClipX * 0.45 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Tensor', 64, 128, 0, 0, 128, 256);
	Xpos = Canvas.ClipX * 0.8 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Vampire', 64, 128, 0, 0, 128, 256);

	Xpos = Canvas.ClipX * 0.1 - 64;
	Ypos += 192;

	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Trooper', 64, 128, 0, 0, 128, 256);
	Xpos = Canvas.ClipX * 0.45 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Snake', 64, 128, 0, 0, 128, 256);
	Xpos = Canvas.ClipX * 0.8 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Hitman', 64, 128, 0, 0, 128, 256);

	Ypos += 192;
	Xpos = Canvas.ClipX * 0.45 - 64;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(texture'Cyborg', 64, 128, 0, 0, 128, 256);

}

simulated function DrawUS( canvas Canvas )
{
local float XL, YL, X, Y;

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !bSetStart )
		{
		//Speed = 0.00625;
		Speed = 0.005;
		//Universal:
		a = 3;
		b = 3.05;
		l = 3.1;
		d = 3.15;
		e = 3.2;
		f = 3.25;
		g = 3.3;
		h = 3.35;
		j = 3.4;
		//Soldiers:
		k = 3.5;
		r = 3.55;
		m = 3.6;
		n = 3.63;
		o = 3.68;
		p = 3.73;
		q = 3.78;
		s = 3.83;
		bSetStart = True;
		}

	XL = Canvas.ClipX * 0.5;
	YL = Canvas.ClipY * 0.5 - 10;


	//Draw U
	X = Cos(a);
	Y = Sin(a);
	Canvas.SetPos(XL + YL * X  , YL + YL * Y );
	Canvas.DrawText("U", True);

	a -= Speed;
	if ( a < 0 )
		{
		a = 6.283185307;
		}
	//Draw n
	X = Cos(b);
	Y = Sin(b);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("n", True);

	b -= Speed;
	if ( b < 0 )
		{
		b = 6.283185307;
		}
	//Draw i
	X = Cos(l);
	Y = Sin(l);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("i", True);

	l -= Speed;
	if ( l < 0 )
		{
		l = 6.283185307;
		}
	//Draw v
	X = Cos(d);
	Y = Sin(d);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("v", True);

	d -= Speed;
	if ( d < 0 )
		{
		d = 6.283185307;
		}
	//Draw e
	X = Cos(e);
	Y = Sin(e);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("e", True);

	e -= Speed;
	if ( e < 0 )
		{
		e = 6.283185307;
		}
	//Draw r
	X = Cos(f);
	Y = Sin(f);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("r", True);

	f -= Speed;
	if ( f < 0 )
		{
		f = 6.283185307;
		}
	//Draw s
	X = Cos(g);
	Y = Sin(g);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("s", True);

	g -= Speed;
	if ( g < 0 )
		{
		g = 6.283185307;
		}
	//Draw a
	X = Cos(h);
	Y = Sin(h);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("a", True);

	h -= Speed;
	if ( h < 0 )
		{
		h = 6.283185307;
		}
	//Draw l
	X = Cos(j);
	Y = Sin(j);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("l", True);

	j -= Speed;
	if ( j < 0 )
		{
		j = 6.283185307;
		}
	//Draw S
	X = Cos(k);
	Y = Sin(k);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("S", True);

	k -= Speed;
	if ( k < 0 )
		{
		k = 6.283185307;
		}
	//Draw o
	X = Cos(r);
	Y = Sin(r);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("o", True);

	r -= Speed;
	if ( l < 0 )
		{
		r = 6.283185307;
		}
	//Draw l
	X = Cos(m);
	Y = Sin(m);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("l", True);

	m -= Speed;
	if ( l < 0 )
		{
		m = 6.283185307;
		}
	//Draw d
	X = Cos(n);
	Y = Sin(n);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("d", True);

	n -= Speed;
	if ( l < 0 )
		{
		n = 6.283185307;
		}
	//Draw i
	X = Cos(o);
	Y = Sin(o);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("i", True);

	o -= Speed;
	if ( l < 0 )
		{
		o = 6.283185307;
		}
	//Draw e
	X = Cos(p);
	Y = Sin(p);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("e", True);

	p -= Speed;
	if ( l < 0 )
		{
		p = 6.283185307;
		}
	//Draw r
	X = Cos(q);
	Y = Sin(q);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("r", True);

	q -= Speed;
	if ( l < 0 )
		{
		q = 6.283185307;
		}
	//Draw s
	X = Cos(s);
	Y = Sin(s);
	Canvas.SetPos(XL + YL * X , YL + YL * Y );
	Canvas.DrawText("s", True);

	s -= Speed;
	if ( l < 0 )
		{
		s = 6.283185307;
		}
}

//  simulated function DrawMonsterInfo(Canvas Canvas)  //Function renamed for variable C
simulated function DrawMonsterInfo(Canvas C)
{
/*   
      **********REPLACED FUNCTION- KEEP FOR VARIABLE CHECK**********

	local Pawn P;
	local float 	Ypos, XL, YL, Xpos, Dist;
	local Vector	dir;
	local Vector	loc;
	local Vector	X,Y,Z;

	if (PlayerOwner == None)
	{
		return;
	}

	GetAxes(Owner.Rotation, X, Y, Z);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = GoldColor;
	Canvas.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'Pawn', P, 1500, Owner.Location, true)
		{

		Dir = P.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		Canvas.StrLen(P.Health, XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * Canvas.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > Canvas.ClipX - XL)
				{
				Xpos = Canvas.ClipX - XL;
				}
			YPos = 0.5 * Canvas.ClipY * (1 - 1.4 * (Dir Dot Z));
			Canvas.SetPos(Xpos , YPos );
			Canvas.DrawText(P.Health, true);
			}
		}

     *******END OF REPLACED FUNCTION *******/
     
        //local ScriptedPawn thisPawn;
        // Lets add bots, shall we
        local Pawn thisPawn;
        local UniversalSoldiersWeapon USWthisPawn;
	local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
	local rotator CamRot;
	local Actor Camera;
	local float BaseBeaconScale, BeaconScale, Dist, DistScale;
	local float TanFOVx, TanFOVy;
	local float TanX, TanY;
	local float dx, dy, FontY;
	local string BeaconText;

	C.Style = ERenderStyle.STY_Masked;

	if (C.ClipX > 1024)
		C.Font = Font'BeaconNameFontLarge';
	else if (C.ClipX > 640)
		C.Font = Font'BeaconNameFontMedium';
	else
		C.Font = Font'BeaconNameFontSmall';
	
	C.SetPos(0, 0);
	C.TextSize("X", dx, FontY);
	BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;
	
        C.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

	TanFOVx = Tan(C.ViewPort.Actor.FOVAngle / 114.591559);
	TanFOVy = (C.ClipY / C.ClipX) * TanFOVx;
	GetAxes(CamRot, X, Y, Z);
	
	C.bNoSmooth = False;
	C.Style = ERenderStyle.STY_Masked;
	//foreach AllActors(class'ScriptedPawn', thisPawn)
	// To add bots to the HUD health overlay:
	foreach AllActors(class'Pawn', thisPawn)
        {
		  if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden )
		    {
                        TargetDir = thisPawn.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
			TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
			DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);

			if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(thisPawn.Location, CamLoc) || FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc))) 
                        {
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;
				
				dx = C.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = C.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				
				C.DrawColor = BeaconColor;
				C.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);
				//C.DrawIcon(TeamBeaconIcon, BeaconScale);

				if (DistScale == 1.0)
                                {
					//BeaconText = thisPawn.PlayerReplicationInfo.PlayerName;
					if (C.ClipX > 600)
					         // Drop the brackets:
						BeaconText = "" $ thisPawn.Health $ "";

					// shadow
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
					C.DrawColor = BeaconColor * 0.125;
					C.DrawTextClipped(BeaconText, False);

					// color
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
					C.DrawColor = BeaconColor;
					C.DrawTextClipped(BeaconText, False);
				}
			}
		}
	}
	// ###################################################
	foreach AllActors(class'UniversalSoldiersWeapon', USWthisPawn)
        {
		  if ( USWthisPawn != none && USWthisPawn != Camera && !USWthisPawn.bHidden )
		    {
                        TargetDir = USWthisPawn.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
			TargetDir = Normal(TargetDir + vect(0,0,1) * USWthisPawn.CollisionHeight);
			DistScale = FMin(100.0 * USWthisPawn.CollisionRadius / Dist, 1.0);

			if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(USWthisPawn.Location, CamLoc) || FastTrace(USWthisPawn.Location + vect(0,0,0.8) * USWthisPawn.CollisionHeight, CamLoc)))
                        {
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;
				
				dx = C.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = C.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				
				C.DrawColor = USWthisPawn.HUDcolor;
				C.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);
				//C.DrawIcon(TeamBeaconIcon, BeaconScale);

				if (DistScale == 1.0)
                                {
					//BeaconText = thisPawn.PlayerReplicationInfo.PlayerName;
					if (C.ClipX > 600)
					         // Drop the brackets:
						BeaconText = "" $ USWthisPawn.HUDname $ "";

					// shadow
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
					C.DrawColor = USWthisPawn.HUDcolor * 0.125;
					C.DrawTextClipped(BeaconText, False);

					// color
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
					C.DrawColor = USWthisPawn.HUDcolor;
					C.DrawTextClipped(BeaconText, False);
				}
			}
		}
	}
}

function SetKeybinds()
{
local string KeyName,ID,Value,NewValue;
local PlayerPawn P;

	P = PlayerPawn(Owner);

	KeyName = P.ConsoleCommand( "KEYNAME "$37 );
	ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
	Value = Right(ID,17);
	if ( Value != "mutate PrevPlayer" )
		{
		//Set mutate PrevPlayer:
		NewValue = ID$" | mutate PrevPlayer";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		//set mutate NextPlayer:
		KeyName = P.ConsoleCommand( "KEYNAME "$39 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		NewValue = ID$" | mutate NextPlayer";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		//set mutate SelectPlayer:
		KeyName = P.ConsoleCommand( "KEYNAME "$13 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		NewValue = ID$" | mutate SelectPlayer";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		//set mutate ViewCharacter:
		KeyName = P.ConsoleCommand( "KEYNAME "$117 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		NewValue = ID$" | mutate ViewCharacter";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		//set mutate UseStats:
		KeyName = P.ConsoleCommand( "KEYNAME "$118 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		NewValue = ID$" | mutate UseStats";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		//set mutate bShop:
		KeyName = P.ConsoleCommand( "KEYNAME "$119 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		NewValue = ID$" | mutate bShop";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		}

}

function DrawSoldiers( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL;

	UpdateRankAndSpread();

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY - 140);
	Canvas.DrawTile(texture'Icon_Soldiers', 32, 32, 0, 0, 64, 64);

	Canvas.SetPos(34, Canvas.ClipY - 137);
	Canvas.DrawText(Rank$"/"$US_GRI(PlayerPawn(Owner).GameReplicationInfo).NumSoldiers);
}

function DrawMonsters( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL;

	UpdateRankAndSpread();

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY - 210);
	Canvas.DrawTile(texture'Icon_Monsters', 32, 32, 0, 0, 64, 64);

	Canvas.SetPos(34, Canvas.ClipY - 207);
	Canvas.DrawText(US_GRI(PlayerPawn(Owner).GameReplicationInfo).NumMonsters);
}

function UpdateRankAndSpread()
{
	local PlayerReplicationInfo PRI;
	local int HighScore;
	local int i, j;

	PlayerCount = 0;
	HighScore = -100;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

function DrawTimeInfo( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL;
local int NL;
local US_GRI GRI;

	GRI = US_GRI(PlayerPawn(Owner).GameReplicationInfo);

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.bCenter = true;
	Canvas.SetPos(0, 0);
	Minutes = US_GRI(PlayerPawn(Owner).GameReplicationInfo).RemainingTime/60;
	Seconds = US_GRI(PlayerPawn(Owner).GameReplicationInfo).RemainingTime % 60;
	Canvas.DrawText(Minutes$":"$TwoDigitString(Seconds), true);
	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	Canvas.SetPos(0, 20);
	Canvas.DrawText("Version:"@version);
	Canvas.bCenter = false;
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(0, 65);
	Canvas.DrawText("F2 = Show statistics");
	Canvas.SetPos(0, 80);
	Canvas.DrawText("F6 = Show Character");
	Canvas.SetPos(0, 95);
	Canvas.DrawText("F7 = Statpoint menu");
	Canvas.SetPos(0, 110);
	Canvas.DrawText("F8 = Items menu");
	
	//Level up:
	NL = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Level * 5000 * US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Level - PlayerPawn(Owner).PlayerReplicationInfo.Score;
	Canvas.SetPos(0, 125);
	Canvas.DrawText("Next level:"@NL);

	Canvas.DrawColor = GoldColor;
	Canvas.StrLen(Level.Day$"-"$Level.Month$"-"$Level.Year$" "$TwoDigitString(Level.Hour)$":"$TwoDigitString(Level.Minute)$":"$TwoDigitString(Level.Second), XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, 0);
	Canvas.DrawText(Level.Day$"-"$Level.Month$"-"$Level.Year$" "$TwoDigitString(Level.Hour)$":"$TwoDigitString(Level.Minute)$":"$TwoDigitString(Level.Second));
}
/*
function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}
*/
simulated function RenderIntro(Canvas Canvas)
{

	if ( bLogoFadeIn )
		{
		LogoFadeColor++;
		if ( LogoFadeColor > 255 )
			{
			LogoFadeColor = 255;
			}
		}
	else if ( bLogoFadeOut )
		{
		LogoFadeColor--;
		if ( LogoFadeColor < 0 )
			{
			LogoFadeColor = 0;
			}
		}

	if (ShowIntroTime < 50 )
		{
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor.R = LogoFadeColor;
		Canvas.DrawColor.G = LogoFadeColor;
		Canvas.DrawColor.B = LogoFadeColor;

		Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 1);
		if ( ShowIntroTime < 5 )
			Canvas.DrawTile(texture'USlogo', 512, 64, 0, 0, 512, 64);

		else if ( ShowIntroTime < 6 )
			{
			Canvas.DrawTile(texture'USlogoA', 512, 64, 0, 0, 512, 64);
			if ( !bShot1 )
				{
				PlayerPawn(Owner).PlaySound(Sound'BotPack.SniperRifle.SniperFire',,2.0);
				bShot1 = True;
				}
			}

		else if ( ShowIntroTime < 7 )
			{
			Canvas.DrawTile(texture'USlogoB', 512, 64, 0, 0, 512, 64);
			if ( !bShot2 )
				{
				PlayerPawn(Owner).PlaySound(Sound'BotPack.SniperRifle.SniperFire',,2.0);
				bShot2 = True;
				}
			}

		else if ( ShowIntroTime < 20 )
			{
			Canvas.DrawTile(texture'USlogoC', 512, 64, 0, 0, 512, 64);
			if ( !bShot3 )
				{
				PlayerPawn(Owner).PlaySound(Sound'BotPack.SniperRifle.SniperFire',,2.0);
				bShot3 = True;
				}
			}
		if ( ShowIntroTime > 8 )
			{
			bLogoFadeOut = True;
			bLogoFadeIn = False;
			}
		}
}

function Destroyed()
{
	//Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function SetDamage(vector HitLoc, float damage)
{
	local int i, best;
	local vector X,Y,Z;
	local float Max, XOffset, YOffset;

	if ( Level.bDropDetail || !PlayerOwner.IsA('TournamentPlayer') )
		return;

	for ( i=0; i<4; i++ )
		if ( Level.TimeSeconds - HitTime[i] > Max )
		{
			best = i;	
			Max = Level.TimeSeconds - HitTime[i];
		}

	HitTime[best] = Level.TimeSeconds;
	HitDamage[best] = FClamp(Damage * 0.06,2,4);
	GetAxes(Owner.Rotation,X,Y,Z);
	XOffset = - 0.5 * FClamp((Y Dot HitLoc)/CollisionRadius , -1, 1);
	YOffset = -0.5 * FClamp((Z Dot HitLoc)/CollisionHeight , -1, 1);

	// hack for positions around head or near legs
	if ( YOffset < -0.35 )
	{
		XOffset *= 0.3;
		YOffset = FMax(HitPos[best].Y, -0.45);
	}
	else if ( YOffset > 0.1 )
	{
		if ( abs(XOffset) < 0.25 )
		{
			if ( XOffset > 0 )
				XOffset = 0.25;
			else
				XOffset = -0.25;
		}				
		YOffset = FMin(YOffset, 0.4);
	}

	HitPos[best].X = 128 * (0.5 + XOffset) - 0.5 * 25 * HitDamage[best];
	HitPos[best].Y = 256 * (0.5 + YOffset) - 0.5 * HitDamage[Best] * 64;
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);

	SetKeybinds();
}

exec function SetHUDR(int n)
{
	FavoriteHUDColor.R = Clamp(n,0,16);
}

exec function SetHUDG(int n)
{
	FavoriteHUDColor.G = Clamp(n,0,16);
}

exec function SetHUDB(int n)
{
	FavoriteHUDColor.B = Clamp(n,0,16);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

exec function GrowHUD()
{
	if ( bHideHUD )
		bHideHud = false;
	else if ( bHideAmmo )
		bHideAmmo = false;
	else if ( bHideFrags )
		bHideFrags = false;
	else if ( bHideTeamInfo )
		bHideTeamInfo = false;
	else if ( bHideAllWeapons )
		bHideAllWeapons = false;
	else if ( bHideStatus )
		bHideStatus = false;
	else 
		WeaponScale = 1.0;

	SaveConfig();
}

exec function ShrinkHUD()
{
	if ( !bLowRes && (WeaponScale * HUDScale > 0.8) )
		WeaponScale = 0.8/HUDScale;
	else if ( !bHideStatus )
		bHideStatus = true;
	else if ( !bHideAllWeapons )
		bHideAllWeapons = true;
	else if ( !bHideTeamInfo )
		bHideTeamInfo = true;
	else if ( !bHideFrags )
		bHideFrags = true;
	else if ( !bHideAmmo )
		bHideAmmo = true;
	else
		bHideHud = true;

	SaveConfig();
}
	
simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

simulated function DrawStatus(Canvas Canvas)
{
	local float ChestAmount, ThighAmount, XL, YL, XL2, RelicY;
	Local int ArmorAmount,i,NumJumps;
	Local inventory Inv,BestArmor;
	local bool bChestArmor, bShieldbelt, bThighArmor, bJumpBoots;

	RelicY = Canvas.ClipY * 0.5 - 200;
	ArmorAmount = 0;
	i = 0;
	BestArmor=None;
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{ 
		if (Inv.bIsAnArmor) 
		{
			if ( Inv.IsA('UT_Shieldbelt') )
				bShieldbelt = true;
			else if ( Inv.IsA('Thighpads') )
			{
				ThighAmount += Inv.Charge;
				bThighArmor = true;
			}
			else
			{ 
				bChestArmor = true;
				ChestAmount += Inv.Charge;
			}
			ArmorAmount += Inv.Charge;
		}
		else if ( Inv.IsA('UT_JumpBoots') )
			{
			bJumpBoots = true;
			NumJumps = Inv.Charge;
			}
		else
		{
			i++;
			if ( i > 100 )
				break; // can occasionally get temporary loops in netplay
		}
	}
	
	if (PawnOwner.IsA('PlayerPawn'))
		{
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen(PawnOwner.Health, XL, YL);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = BlueColor;
		Canvas.SetPos(Canvas.ClipX - 96 - XL, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementL', 32, 40, 0, 0, 32, 64);
		Canvas.SetPos(Canvas.ClipX - 64 - XL, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementM', XL, 40, 0, 0, XL, 64);
		Canvas.SetPos(Canvas.ClipX - 64, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementR', 32, 40, 0, 0, 32, 64);
		Canvas.SetPos(Canvas.ClipX - 30, Canvas.ClipY - 35);
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawTile(Texture'Heart', 30, 30, 0, 0, 64, 64);

		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(Canvas.ClipX - 64 - XL ,Canvas.ClipY - YL + 2);
		Canvas.DrawColor = GoldColor;
		Canvas.DrawText(PawnOwner.Health);

		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen(ArmorAmount, XL, YL);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = BlueColor;
		Canvas.SetPos(Canvas.ClipX - 64 - XL, Canvas.ClipY - 82);
		Canvas.DrawTile(Texture'ScoreElementL', 32, 40, 0, 0, 32, 64);
		Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY - 82);
		Canvas.DrawTile(Texture'ScoreElementM', XL, 40, 0, 0, XL, 64);
		Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 82);
		Canvas.DrawTile(Texture'ScoreElementR', 32, 40, 0, 0, 32, 64);
		Canvas.SetPos(Canvas.ClipX - 30, Canvas.ClipY - 77);
		Canvas.DrawColor = WhiteColor;
		Canvas.DrawTile(Texture'Shield', 30, 30, 0, 0, 64, 64);

		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(Canvas.ClipX - 32 - XL ,Canvas.ClipY - YL - 40);
		Canvas.DrawColor = GoldColor;
		Canvas.DrawText(ArmorAmount);

		if ( NumJumps > 0 )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Canvas.ClipX - 32 , 0);
			Canvas.DrawTile(Texture'JumpBoots', 32, 32, 0, 0, 32, 32);
			Canvas.StrLen(NumJumps, XL, YL);
			Canvas.SetPos(Canvas.ClipX - XL , 32);
			Canvas.DrawText(NumJumps);
			}
		if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasSpeed )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX - 64 , RelicY);
			Canvas.DrawTile(Texture'SpeedRelic', 64, 64, 0, 0, 64, 64);
			RelicY += 65;
			}
		if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasDamage )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX - 64 , RelicY);
			Canvas.DrawTile(Texture'DamageRelic', 64, 64, 0, 0, 64, 64);
			RelicY += 65;
			}
		if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasDefense )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX - 64 , RelicY);
			Canvas.DrawTile(Texture'DefenceRelic', 64, 64, 0, 0, 64, 64);
			RelicY += 65;
			}
		if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasAura )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX - 64 , RelicY);
			Canvas.DrawTile(Texture'AuraRelic', 64, 64, 0, 0, 64, 64);
			RelicY += 65;
			}
		if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasHealthRegenRelic )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX - 64 , RelicY);
			Canvas.DrawTile(Texture'HealthRegenRelic', 64, 64, 0, 0, 64, 64);
			RelicY += 65;
			}
		if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasRadar )
			{
			Canvas.DrawColor = WhiteColor;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.SetPos(Canvas.ClipX - 64 , RelicY);
			Canvas.DrawTile(Texture'RadarRelic', 64, 64, 0, 0, 64, 64);
			RelicY += 65;
			}
		}
}

simulated function DrawFragCount(Canvas Canvas)
{
local float XL, YL, XL2;

	if (PawnOwner.IsA('PlayerPawn'))
		{
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen(int(PawnOwner.PlayerReplicationInfo.Score), XL, YL);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = BlueColor;
		Canvas.SetPos(0, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementL', 32, 40, 0, 0, 32, 64);
		Canvas.SetPos(32, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementM', XL, 40, 0, 0, XL, 64);
		Canvas.SetPos(32 + XL, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementR', 32, 40, 0, 0, 32, 64);
		Canvas.Style = ERenderStyle.STY_Normal;
		
		Canvas.SetPos(32 ,Canvas.ClipY - YL + 2);
		Canvas.DrawColor = GoldColor;
		Canvas.DrawText(int(PawnOwner.PlayerReplicationInfo.Score));
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("Score:", XL2, YL);
		Canvas.SetPos(32 + XL * 0.3, Canvas.ClipY - 40);
		Canvas.DrawText("Score:");
		}

}


simulated function DrawGameSynopsis(Canvas Canvas)
{
local float XL, YL;

	if ( (PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.IsA('PlayerPawn'))
		return;
	//Draw money:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0 , Canvas.ClipY - 75);
	Canvas.DrawTile(Texture'DollarIcon', 32, 32, 0, 0, 64, 64);
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.SetPos(34 , Canvas.ClipY - 72);
	Canvas.DrawText(US_PRI(PlayerOwner.PlayerReplicationInfo).Money);
	//Draw StatPoints:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0 , Canvas.ClipY - 109);
	Canvas.DrawTile(Texture'StatPointIcon', 32, 32, 0, 0, 64, 64);
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.SetPos(34 , Canvas.ClipY - 106);
	Canvas.DrawText(US_PRI(PlayerOwner.PlayerReplicationInfo).StatPoints);
	//Draw Souls:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0 , Canvas.ClipY - 175);
	Canvas.DrawTile(Texture'SoulIcon', 32, 32, 0, 0, 64, 64);
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.SetPos(34 , Canvas.ClipY - 172);
	Canvas.DrawText(US_PRI(PlayerOwner.PlayerReplicationInfo).Souls$"/"$US_PRI(PlayerOwner.PlayerReplicationInfo).BossesKilled);

	DrawTimeInfo(Canvas);
	DrawSoldiers(Canvas);
	if ( US_GRI(PlayerPawn(Owner).GameReplicationInfo).NumMonsters > 0 )
		{
		DrawMonsters(canvas);
		DrawMonsterInfo(Canvas);
		}
}

simulated function DrawWeapons(Canvas Canvas)
{
local float XL, YL, XL2;

	if ( PawnOwner.Weapon != None )
		{
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen(PawnOwner.Weapon.ItemName, XL, YL);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = BlueColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 32 - 0.5 * XL, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementL', 32, 40, 0, 0, 32, 64);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementM', XL, 40, 0, 0, 32, 64);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 0.5 * XL, Canvas.ClipY - 40);
		Canvas.DrawTile(Texture'ScoreElementR', 32, 40, 0, 0, 32, 64);
		Canvas.Style = ERenderStyle.STY_Normal;

		Canvas.StrLen(PawnOwner.Weapon.ItemName, XL, YL);
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - YL +2);
		Canvas.DrawText(PawnOwner.Weapon.ItemName, False);
		if ( PawnOwner.Weapon.AmmoType != none && PawnOwner.Weapon.AmmoType.AmmoAmount != 0 )
			{
			Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
			Canvas.StrLen("Ammo:"@PawnOwner.Weapon.AmmoType.AmmoAmount, XL2, YL);
			Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL2, Canvas.ClipY - 40);
			Canvas.DrawText("Ammo:"@PawnOwner.Weapon.AmmoType.AmmoAmount);
			}
		}


	//AmmoScale = FClamp(88.0 * WeapScale * WeaponSlot[i].AmmoType.AmmoAmount/WeaponSlot[i].AmmoType.MaxAmmo, 0, 88);
	
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
local float XL, YL, XPos, YPos, FadeValue;
local string Message;
local int M, i, j, k, XOverflow;
local float OldOriginX;
local US_PRI IPRI;

	RenderIntro(Canvas);


	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	//Draw Character Screen on start:
	if ( US_PRI(PlayerOwner.PlayerReplicationInfo).bChoseCharacter )
		{
		DrawBackground(Canvas);
		DrawCharFrame(Canvas);
		RenderIntro(Canvas);
		Return;
		}

	//Draw Character(F6):
	if ( US_PRI(PlayerOwner.PlayerReplicationInfo).bViewCharacter )
		{
		DrawBackground2(Canvas);
		DrawCharFrame(Canvas);
		Return;
		}

	//Draw Stats Screen:
	if ( US_PRI(PlayerOwner.PlayerReplicationInfo).bStats )
		{
		DrawStatsBackground(Canvas);
		DrawStatsFrame(Canvas);
		Return;
		}

	//Draw Shop Screen:
	if ( US_PRI(PlayerOwner.PlayerReplicationInfo).bShop )
		{
		DrawShopBackground(Canvas);
		DrawShopFrame(Canvas);
		Return;
		}

	if ( bShowInfo )
		{
		DrawF2Background(Canvas);
		DrawF2logo(Canvas);
		DrawUS(Canvas);
		return;
		}

	if ( !PlayerOwner.bShowScores && !bForceScores )
		{
		DrawWeapons(Canvas);
		}

	DrawStatus(Canvas);
	DrawFragCount(Canvas);
	DrawGameSynopsis(Canvas);
	DrawIdentifyInfo(Canvas);
	DrawLevelUp(canvas);
	//DrawDroppedWeapons(Canvas);

	if ( US_PRI(PawnOwner.PlayerReplicationInfo).bHasRadar )
			{
			DrawRadar(Canvas);
			}

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		//DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = False;//(FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 4;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	if ( HUDMutator != None )
		HUDMutator.PostRender(Canvas);

	if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}

}

function Timer()
{
	local int i, j;

	Super.Timer();

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

	if ( ShowIntroTime < 50)
		ShowIntroTime++;

}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
local int i;
local Canvas Canvas;

	Super.Tick(DeltaTime);

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;

}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

Simulated function DrawF2Background(Canvas Canvas)
{
local float XL, YL, YL2;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetPos(0, 1);
	Canvas.DrawText(PlayerPawn(Owner).GameReplicationInfo.ServerName);
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL2);
	Canvas.SetPos(0, 1 + YL);
	Canvas.DrawText("Admin:"@PlayerPawn(Owner).GameReplicationInfo.AdminName);
	Canvas.SetPos(0, 1 + YL + YL2);
	Canvas.DrawText("Contact Info:"@PlayerPawn(Owner).GameReplicationInfo.AdminEmail);

	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL2);
	Canvas.DrawColor = RedColor;
	Canvas.SetPos(0, 1 + Canvas.ClipY - YL2 * 2);
	Canvas.DrawText("Universal Soldiers"@version);
	Canvas.SetPos(0, 1 + Canvas.ClipY - YL2 );
	Canvas.DrawText("2010 TheDane - www.thedanesjoint.com");
	Canvas.bCenter = False;
}

Simulated function DrawBackground(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.DrawColor = HeadLineColor;
	Canvas.StrLen("Use left/Right to change character, Enter to select.", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Use left/Right to change character, Enter to select.");
	Canvas.bCenter = False;

}

Simulated function DrawBackground2(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.DrawColor = HeadLineColor;
	Canvas.StrLen("Use left/Right to chose skill, Enter to delete.", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Use left/Right to chose skill, Enter to delete.");
	Canvas.bCenter = False;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 1);
	Canvas.DrawTile(texture'USlogo', 512, 64, 0, 0, 512, 64);
}

Simulated function DrawCharFrame(Canvas Canvas)
{
local float XL, YL, Xpos, Ypos, Ypos2;
local US_PRI IPRI;
local string PNAME, BaseWeapon, Item1, Item2, Item3;
local int BaseHealth, BaseArmor, Level;
local int BaseDamage;

	//Assign variables:
	PNAME = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).PlayerModel;
	BaseWeapon = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).BaseWeapon;
	BaseHealth = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).BaseHealth;
	BaseArmor = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).BaseArmor;
	BaseDamage = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).BaseDamage;
	Level = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Level;

	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Item1 != "" )
		{
		Item1 = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Item1;
		}
	else
		{
		Item1 = "None.";
		}
	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Item2 != "" )
		{
		Item2 = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Item2;
		}
	else
		{
		Item2 = "None.";
		}
	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Item3 != "" )
		{
		Item3 = US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Item3;
		}
	else
		{
		Item3 = "None.";
		}

	Xpos = Canvas.ClipX * 0.5 + 94;
	Ypos = Canvas.ClipY * 0.5 - 80;
	Ypos2 = Ypos + 140;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;

	//Frame:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 193);
	Canvas.DrawTile(texture'Frame', 512, 396, 0, 0, 512, 396);

	//Draw Headline:
	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bViewCharacter )
		{
		Canvas.DrawColor = HeadLineColor;
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen("Viewing your character!", XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 187);
		Canvas.DrawText("Viewing your character!");
		}
	else
		{
		Canvas.DrawColor = HeadLineColor;
		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
		Canvas.StrLen("Chose your character!", XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 187);
		Canvas.DrawText("Chose your character!");
		}

	//Draw Character name:
	Canvas.DrawColor = GoldColor;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(PNAME, XL, YL);
	Canvas.SetPos(Xpos - 256 - 0.5 * XL, Canvas.ClipY * 0.5 - 158);
	Canvas.DrawText(PNAME);

	//Draw Character:
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 222, Canvas.ClipY * 0.5 - 100);

	if ( PNAME == "Cyborg")
		{
		Canvas.DrawTile(texture'Cyborg', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Hitman")
		{
		Canvas.DrawTile(texture'Hitman', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Snake")
		{
		Canvas.DrawTile(texture'Snake', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Trooper")
		{
		Canvas.DrawTile(texture'Trooper', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Vampire")
		{
		Canvas.DrawTile(texture'Vampire', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Tensor")
		{
		Canvas.DrawTile(texture'Tensor', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Cyclop")
		{
		Canvas.DrawTile(texture'Cyclop', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Ninja")
		{
		Canvas.DrawTile(texture'Ninja', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Gordon")
		{
		Canvas.DrawTile(texture'Gordon', 128, 256, 0, 0, 128, 256);
		}
	else if ( PNAME == "Freezy")
		{
		Canvas.DrawTile(texture'Freezy', 128, 256, 0, 0, 128, 256);
		}

	//Draw Extras:
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen("Extras:", XL, YL);
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos2 - 1.5 * YL);
	Canvas.DrawText("Extras:");
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

		Canvas.StrLen("ArmorRegen: "$US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasArmorRegen, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos2);
		Canvas.DrawText("ArmorRegen: "$US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasArmorRegen);
		Canvas.StrLen("HealthRegen: "$US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasHealthRegen, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos2 + YL);
		Canvas.DrawText("HealthRegen: "$US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasHealthRegen);
		Canvas.StrLen("AmmoRegen: "$US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasAmmoRegen, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos2 + 2 * YL);
		Canvas.DrawText("AmmoRegen: "$US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasAmmoRegen);

	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Item1" )
		Canvas.DrawColor = HeadLineColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.StrLen("Item1: "$Item1, XL, YL);
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos2 + 3 * YL);
	Canvas.DrawText("Item1: "$Item1);
	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Item2" )
		Canvas.DrawColor = HeadLineColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.StrLen("Item2: "$Item2, XL, YL);
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos2 + 4 * YL);
	Canvas.DrawText("Item2: "$Item2);
	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Item3" )
		Canvas.DrawColor = HeadLineColor;
	else
		Canvas.DrawColor = GreenColor;
	Canvas.StrLen("Item3: "$Item3, XL, YL);
	Canvas.SetPos(Xpos - 0.5 * XL, Ypos2 + 5 * YL);
	Canvas.DrawText("Item3: "$Item3);

	//Draw Character Skills:
		Canvas.DrawColor = GreenColor;
		Canvas.StrLen("Weapon: "$BaseWeapon, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos);
		Canvas.DrawText("Weapon: "$BaseWeapon);
		Canvas.StrLen("Health: "$BaseHealth, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos + YL);
		Canvas.DrawText("Health: "$BaseHealth);
		Canvas.StrLen("Armor: "$BaseArmor, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos + 2 * YL);
		Canvas.DrawText("Armor: "$BaseArmor);
		Canvas.StrLen("Damage: "$BaseDamage$"%", XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos + 3 * YL);
		Canvas.DrawText("Damage: "$BaseDamage$"%");
		Canvas.StrLen("Characters Skills:", XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos - 3 * YL);
		Canvas.DrawText("Characters Skills:");
		Canvas.StrLen("Level: "$Level, XL, YL);
		Canvas.SetPos(Xpos - 0.5 * XL, Ypos - 1.5 * YL);
		Canvas.DrawText("Level: "$Level);



	//Cycle Headline Color:
	HeadLineColor.R = HeadLineFadeColor;
	HeadLineColor.G = HeadLineFadeColor;
	HeadLineColor.B = HeadLineFadeColor;
	HeadLineFadeColor--;
	if ( HeadLineFadeColor < 0 )
		{
		HeadLineFadeColor = 255;
		}
}

Simulated function DrawStatsBackground(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.DrawColor = HeadLineColor;
	Canvas.StrLen("Use left/Right to change skill, Enter to upgrade.", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Use left/Right to change skill, Enter to upgrade.");
	Canvas.bCenter = False;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 1);
	Canvas.DrawTile(texture'USlogo', 512, 64, 0, 0, 512, 64);
}

Simulated function DrawStatsFrame(Canvas Canvas)
{
local float XL, YL, Xpos, Ypos, Ypos2;
local US_PRI IPRI;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;

	//Frame:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 193);
	Canvas.DrawTile(texture'Frame2', 512, 396, 0, 0, 512, 396);

	//Draw Headline:
	Canvas.DrawColor = HeadLineColor;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("Distribute your statpoints!", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 187);
	Canvas.DrawText("Distribute your statpoints!");

	//Cycle Headline Color:
	HeadLineColor.R = HeadLineFadeColor;
	HeadLineColor.G = HeadLineFadeColor;
	HeadLineColor.B = HeadLineFadeColor;
	HeadLineFadeColor--;
	if ( HeadLineFadeColor < 0 )
		{
		HeadLineFadeColor = 255;
		}

	Canvas.bCenter = True;

	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentSkill == "Health" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 140);
		Canvas.DrawText("BaseHealth skill");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawText("Current BaseHealth:"@US_PRI(PawnOwner.PlayerReplicationInfo).BaseHealth);
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100 + 3 * YL);
		Canvas.DrawText("This skill is the base health your character has.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100 + 4 * YL);
		Canvas.DrawText("Your character will respawn with this health level.");
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentSkill == "Armor" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 140);
		Canvas.DrawText("BaseArmor skill");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawText("Current BaseArmor:"@US_PRI(PawnOwner.PlayerReplicationInfo).BaseArmor);
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100 + 3 * YL);
		Canvas.DrawText("This skill is the base armor your character has.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100 + 4 * YL);
		Canvas.DrawText("Your character will respawn with this armor level.");
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentSkill == "Damage" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 140);
		Canvas.DrawText("BaseDamage skill");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawText("Current BaseDamage:"@US_PRI(PawnOwner.PlayerReplicationInfo).BaseDamage$"%");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100 + 3 * YL);
		Canvas.DrawText("This skill is the base damage your character inflicts on enemies.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 100 + 4 * YL);
		Canvas.DrawText("Your character will respawn with this damage level.");
		}
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY * 0.5 + 120 );
	Canvas.DrawText("You have"@US_PRI(PawnOwner.PlayerReplicationInfo).StatPoints$" statpoints available.");

}

Simulated function DrawShopBackground(Canvas Canvas)
{
local float XL, YL;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.DrawColor = HeadLineColor;
	Canvas.StrLen("Use left/Right to change item, Enter to purchase.", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Use left/Right to change item, Enter to purchase.");
	Canvas.bCenter = False;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 1);
	Canvas.DrawTile(texture'USlogo', 512, 64, 0, 0, 512, 64);
}

Simulated function DrawShopFrame(Canvas Canvas)
{
local float XL, YL, Xpos, Ypos, Ypos2;
local US_PRI IPRI;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;

	//Frame:
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, Canvas.ClipY * 0.5 - 193);
	Canvas.DrawTile(texture'Frame2', 512, 396, 0, 0, 512, 396);

	//Draw Headline:
	Canvas.DrawColor = HeadLineColor;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("Pick an item you want to purchase!", XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY * 0.5 - 187);
	Canvas.DrawText("Pick an item you want to purchase!");

	//Cycle Headline Color:
	HeadLineColor.R = HeadLineFadeColor;
	HeadLineColor.G = HeadLineFadeColor;
	HeadLineColor.B = HeadLineFadeColor;
	HeadLineFadeColor--;
	if ( HeadLineFadeColor < 0 )
		{
		HeadLineFadeColor = 255;
		}

	Canvas.bCenter = True;

	if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Translocator" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Translocator Device");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $100");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This device lets you teleport arround the maps.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Throw the module to the location you would like to teleport to.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Though it's not a weapon it can be used to telefrag enemies.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Translocator', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Grapple" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Grappling Hook Device");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $100");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This device helps you transport arround the maps.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Shoot the hook to the location you would like to transport to.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Though it's not a weapon it does cause little damage upon enemies.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Translocator', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "AssaultRifle" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Assault Sniper Rifle");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $500");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("x2 Firing speed.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("x2 Zoom speed.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("up to 45x Zoom.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_SniperRifle', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Enforcer" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Enforcer");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $150");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This weapon is know as Liandri's default weapon.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Good for close combat.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Can be upgraded with Double Universal Enforcer.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Enforcer', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "DoubleEnforcer" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Double Enforcers");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $150");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This weapon is know as Liandri's default weapon.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Good for close combat.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("This will add an extra Enforcer to your armory.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Enforcer', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "SniperRifle" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Sniper Rifle");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $300");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("The classic weapon for long range shooting.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Somewhat usefull for close combat.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Sniper Rifle is the name, Headshot is the game.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_SniperRifle', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "ShockRifle" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Shock Rifle");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $300");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Fires instant hit laser beam or slow plasma ball.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Shoot plasma ball with laser for explosive damage.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Classic all-round weapon.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_ShockRifle', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "BioRifle" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Bio Rifle");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $300");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Wads of Tarydium byproduct are lobbed at a medium rate of fire.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("The wads is a sticky mass that attach to any surface.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Good to block the path for players, and lethal at impact.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_BioRifle', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Eightball" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Rocket Launcher");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $350");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Fires explosive rockets.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Secondary fires explosive grenades.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("A well known dealy choice of weapon.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Eightball', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "FlakCannon" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Flak Cannon");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $350");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Fires chunks that spreads by distance.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Secondary fires explosive chunk grenade.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Dealy on close range.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_FlakCannon', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Minigun" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Minigun");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $300");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Fires bullets at high speed.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Secondary fires the same but spreads the bullets.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Great chance of hitting something, lol.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Minigun', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Pulsegun" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal Pulsegun");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $300");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Fires laser orbs.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Secondary fires laser short range beam.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("A good choice for an all-round weapon.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Pulsegun', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "RazorJack" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Universal RazorJack");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $300");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Fires discs that bounces off surfaces.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Secondly Fires discs that explodes on impact.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("A good choice for corridor fights.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_RazorJack', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Lawgiver" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Lawgiver");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $400");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Greatly improved version of the Enforcer.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Improved hitdamage + headshot.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Can be upgraded with Double Lawgiver.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Enforcer', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "DoubleLawgiver" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Double Lawgiver");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $400");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Greatly improved version of the Enforcer.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Improved hitdamage + headshot.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("This will add an extra Lawgiver to your armory.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Enforcer', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Painless" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Painless");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $600");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Greatly improved version of the Minigun.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Improved hitdamage + explosive impact.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Like the name sais, your enemy will feel no pain.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Minigun', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "TwinLauncher" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("TwinLauncher");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $600");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Greatly improved version of the Rocket launcher.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Fires double rockets.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Secondly fires double grenades.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Eightball', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "Uzi" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("MadMan's Uzi");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $700");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("Very fast firing speed, lots of ammo.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Zoom lense.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Deadliest weapon of all.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Uzi', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "AmmoRegen" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Ammo Regeneration");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $500");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This item slowly regenerates the ammo.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("Essential in maps with little pickups.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Does NOT work with Redeemers.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Ammo', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "HealthRegen" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Health Regeneration");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $500");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This item regenerates your Health.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("+1 Health per second.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("Heals up to your characters BaseHealth amount.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Health', 256, 128, 0, 0, 256, 128);
		}
	else if ( US_PRI(PlayerPawn(Owner).PlayerReplicationInfo).CurrentItem == "ArmorRegen" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 145);
		Canvas.DrawText("Armor Regeneration");
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.StrLen("000", XL, YL);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50);
		Canvas.DrawText("Price: $500");
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 2 * YL);
		Canvas.DrawText("This item regenerates your Armor.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 3 * YL);
		Canvas.DrawText("+1 point per second.");
		Canvas.SetPos(0, Canvas.ClipY * 0.5 + 50 + 4 * YL);
		Canvas.DrawText("If armor zero out it won't regenerate before new pickup.");
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 128, Canvas.ClipY * 0.5 - 100);
		Canvas.DrawTile(texture'Icon_Armor', 256, 128, 0, 0, 256, 128);
		}
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY * 0.5 + 160 );
	Canvas.DrawText("You have"@US_PRI(PawnOwner.PlayerReplicationInfo).Money$"$ to shop with.");
}

defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
     LogoColor=(R=0,G=0,B=0)
     HeadLineColor=(R=0,G=0,B=0)
     IdentifyName="Soldier:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Now watching: "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
     bLogoFadeIn=True
     BlogoFadeOut=False
     version="v1.0"
     bLevelUp=False
     // Added for the new HUD overlay
     TeamBeaconIcon=Texture'TeamBeacon2'
     BeaconColor=(R=255,G=255)
}
